clear all; clc;

% rng(10);

f_c = 3.5e9;        % Frequency

sigma2_dB = -20;
sigma2 = 10.^(sigma2_dB/10);   % Noise power

beta = 3;

P = 10;
N_ports = 4;

W = 10:5:50;

Length = length(W);

Rep = 1000;

NMSE_GPR_MC_noElim = zeros(Length,Rep);
NMSE_GPR_MC_Elim = zeros(Length,Rep);
NMSE_GPR_MC_Elim2 = zeros(Length,Rep);

for qq = 1:Length

    load(['Kernal_W/Kernal_W_' num2str(W(qq)) '.mat']);
    load(['Kernal_W/MC_W_' num2str(W(qq)) '.mat']);

    parfor rp = 1:Rep

        h = CDL_channel(x, f_c);
        h = h/sqrt(mean(diag(Kernal_CDL_mean)));

        h_MC = rxMCMtx^0.5*h;

        [h_hat_GPR,~,~,~] = GPR_multi(x,h_MC,Kernal_CDL_mean, sigma2, P*N_ports, 1);
        NMSE_GPR_MC_noElim(qq,rp) = mag2db(norm(rxMCMtx^-0.5*h_hat_GPR - h)/norm(h));

        [h_hat_GPR,~,~,~] = GPR_multi(x,h_MC,(rxMCMtx^0.5)*Kernal_CDL_mean*(rxMCMtx^0.5)', sigma2, P*N_ports, 1);
        NMSE_GPR_MC_Elim(qq,rp) = mag2db(norm(rxMCMtx^-0.5*h_hat_GPR - h)/norm(h));

        % [h_hat_GPR,~,~,~] = GPR_MC(f_c, x, h, Kernal_CDL_mean, sigma2, P, N_ports);
        [h_hat_GPR,~,~,~] = GPR_multi(x,h,Kernal_CDL_mean, sigma2, P*N_ports, 1);
        NMSE_GPR_MC_Elim2(qq,rp) = mag2db(norm(h_hat_GPR - h)/norm(h));

        fprintf("Rep %d complete.\n", rp);
    end

end

NMSE_GPR_MC_noElim = mean(NMSE_GPR_MC_noElim,2);
NMSE_GPR_MC_Elim = mean(NMSE_GPR_MC_Elim,2);
NMSE_GPR_MC_Elim2 = mean(NMSE_GPR_MC_Elim2,2);

figure; hold on; box on; grid on;
plot(W,NMSE_GPR_MC_noElim,'-ks','LineWidth',1.5);
plot(W,NMSE_GPR_MC_Elim,'-b^','LineWidth',1.5);
plot(W,NMSE_GPR_MC_Elim2,'-rp','LineWidth',1.5);
legend('S-BAR (No suppression)','S-BAR (Suppressing coupling)','S-BAR (Without coupling)','FontSize',11,'Interpreter','latex');
xlabel('Normalized array length $W/\lambda$','Interpreter','latex','FontSize',14);
ylabel('NMSE (dB)','Interpreter','latex','FontSize',14);

save('NMSE_vs_W.mat','W','NMSE_GPR_MC_noElim','NMSE_GPR_MC_Elim','NMSE_GPR_MC_Elim2');


